/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntitiesTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity affectedEnt, Temperature.Trait trait) {
        Level level = affectedEnt.f_19853_;
        AABB aabb = new AABB(affectedEnt.m_20183_()).m_82386_(0.0, (double)(affectedEnt.m_20206_() / 2.0f) - 0.5, 0.0).m_82400_(8.0);
        List entities = affectedEnt.f_19853_.m_6249_((Entity)affectedEnt, aabb, e -> e != affectedEnt);
        double totalTemp = 0.0;
        for (Entity nearbyEnt : entities) {
            Collection entityTemps = ConfigSettings.ENTITY_TEMPERATURES.get().get((Object)nearbyEnt.m_6095_());
            for (EntityTempData tempData : entityTemps) {
                if (!tempData.test(nearbyEnt, (Entity)affectedEnt)) continue;
                double entityTemp = tempData.getTemperature(nearbyEnt, (Entity)affectedEnt);
                AtomicInteger blocksBetween = new AtomicInteger();
                WorldHelper.forBlocksInRay(EntityHelper.getCenterOf((Entity)affectedEnt), EntityHelper.getCenterOf(nearbyEnt), level, (state, pos) -> {
                    if (state.m_60804_((BlockGetter)level, pos)) {
                        blocksBetween.getAndIncrement();
                    }
                }, 3);
                totalTemp += (entityTemp /= (double)(blocksBetween.get() + 1));
            }
        }
        double finalTemp = totalTemp;
        return temp -> temp + finalTemp;
    }
}

